/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

/**************************************************************************
 *
 *	XVID MPEG-4 VIDEO CODEC
 *	image stuff
 *
 *	This program is an implementation of a part of one or more MPEG-4
 *	Video tools as specified in ISO/IEC 14496-2 standard.  Those intending
 *	to use this software module in hardware or software products are
 *	advised that its use may infringe existing patents or copyrights, and
 *	any such use would be at such party's own risk.  The original
 *	developer of this software module and his/her company, and subsequent
 *	editors and their companies, will have no liability for use of this
 *	software or modifications or derivatives thereof.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ***************************************************************************
*/

/**************************************************************************
 *
 *	History:
 *
 *  09.04.2002  PSNR calculations
 *	06.04.2002	removed interlaced edging from U,V blocks (as per spec)
 *  26.03.2002  interlacing support (field-based edging in set_edges)
 *	26.01.2002	rgb555, rgb565
 *	07.01.2001	commented u,v interpolation (not required for uv-block-based)
 *  23.12.2001  removed #ifdefs, added function pointers + init_common()
 *	22.12.2001	cpu #ifdefs
 *	 6.12.2001	inital version; (c)2001 peter ross <pross@cs.rmit.edu.au>
 *
 ***************************************************************************
*/

#include <stdlib.h>
#include <math.h>

#include "image.h"
#include "bilinear8x8.h"
#include "dma_api_DSP.h"
#include "mem_address.h"

#define SAFETY 0 // used to be 64
#define EDGE_SIZE_2  (EDGE_SIZE/2)

void
image_swap(IMAGE * image1, IMAGE * image2)
{
    uint8  *tmp;

    tmp = (uint8 *) ((uint32) image1->y);
    image1->y = (uint8 *) ((uint32) image2->y);
    image2->y = tmp;

    tmp = (uint8 *) ((uint32) image1->u);
    image1->u = (uint8 *) ((uint32) image2->u);
    image2->u = tmp;

    tmp = (uint8 *) ((uint32) image1->v);
    image1->v = (uint8 *) ((uint32) image2->v);
    image2->v = tmp;
}

extern volatile int flag[6];

int
image_output(IMAGE * image, uint16 width, uint16 height,
             uint16 edged_width, uint16 * dst, uint16 dst_stride, int one)
{
    uint8  *py = image->y;
    uint8  *pu = image->u;
    uint8  *pv = image->v;
    uint16  edged_width2 = (edged_width >> 1);
    uint16  dst_stride2 = (dst_stride >> 1);
    //uint16 *dst=(uint16 *)(FRAME_BUFFER);
    int     y, u, v, u_sav, v_sav;
    int     r, g, b;
    int     col, row;
    int     half_width = width >> 1;
    uint16 *clp = (uint16 *) (clip_table_address);
    clp += 384;
    dst += 479;                 //dst += (239 + 240*(uint32)offset_x - offset_y);
    for (row = 0; row < height; row++)
    {
        for (col = 0; col < width; col += 2)
        {
            //y = *py++; 
            y = *py;
            py = (uint8 *) ((uint32) ((uint32) py + (uint32) one));
            u = *pu++ - 128;
            v = *pv++ - 128;
            u_sav = (1814 * (uint32) u) >> 10;
            v_sav = (1435 * (uint32) v) >> 10;

            r = clp[y + v_sav];
            b = clp[y + u_sav];
            g = clp[y - ((352 * (uint32) u - 731 * (uint32) v) >> 10)];
            /*
               // 16-bit 5-6-5
               //           (*(uint16*)dst) = 
               //               ((r & 0xF8) << 8) |
               //               ((g & 0xFC) << 3) |
               //                (b >> 3);
             */
            *dst = ((r >> 3) << 11) | ((g >> 2) << 5) | (b >> 3);
            dst = (uint16 *) ((uint32) ((uint32) dst + (uint32) height));   //dst+=240;           
            y = *py;            //y = *py++;
            py = (uint8 *) ((uint32) ((uint32) py + (uint32) one));
            r = clp[y + v_sav];
            b = clp[y + u_sav];
            g = clp[y - ((352 * (uint32) u - 731 * (uint32) v) >> 10)];
            /*          
               // 16-bit 5-6-5
               //           (*(uint16*)dst) = 
               //               ((r & 0xF8) << 8) |
               //               ((g & 0xFC) << 3) |
               //                (b >> 3);
             */
            *dst = ((r >> 3) << 11) | ((g >> 2) << 5) | (b >> 3);
            dst = (uint16 *) ((uint32) ((uint32) dst + (uint32) height));   //dst += 240; 
        }
        //py = py-1;
        //py += (edged_width-dst_stride);
        py = (uint8
              *) ((uint32) ((uint32) py + (uint32) (edged_width - dst_stride)));
        if (!(row & 0x1))
        {
            pu -= half_width;
            pv -= half_width;
        }
        else
        {
            pu += (edged_width2 - dst_stride2);
            pv += (edged_width2 - dst_stride2);
        }
        dst = (uint16 *) ((uint32) dst - (uint32) ((uint32) one + (uint32) (height * (uint32) width))); //dst -= (1 + 240*(uint32)width); 
    }
    return 0;
}
